var mediaSyncObjects = new Array();
var mediaSyncInterval = 100;

function MediaSync(strMediaEmbedName, strMediaType)
{
	if (strMediaEmbedName == null)
	{
		strMediaEmbedName = "AudioClip";
	}

	if (strMediaType == null)
	{	
		strMediaType = mediaType;
	}
	
	this.mediaType = strMediaType;
	this.embedName = strMediaEmbedName;
	this.enabled = false;
	this.playing = false;
	this.clipRef == null;
	this.events = new EventsObject("play","stop","timer");
	this.id = mediaSyncObjects.length;
	
	mediaSyncObjects[this.id] = this;
	if (this.id == 0)
	{
		MediaIdler();
	}
	
	return this;
}
MediaSync.prototype.resolveClipRef = MediaSyncResolveClipRef;
MediaSync.prototype.start = MediaSyncStart;
MediaSync.prototype.stop = MediaSyncStop;

function MediaSyncStart()
{
	this.enabled = true;
}

function MediaSyncStop()
{
	this.enabled = false;
}

function MediaSyncResolveClipRef()
{
	if (this.clipRef == null)
	{
		if (this.mediaType == "real")
		{
			this.clipRef = RP_getClipRef(this.embedName);
		}
		else if (this.mediaType == "windowsmedia")
		{
			this.clipRef = WM_getClipRef(this.embedName);
		}
		else if (this.mediaType == "flash")
		{
			this.clipRef = FP_getClipRef(this.embedName);
		}
	}
}

function MediaIdler()
{
	var i = 0;
	var obj = null;
	var isPlaying = false;
	
	for (i=0;i<mediaSyncObjects.length;i++)
	{
		obj = mediaSyncObjects[i];
		if (obj.enabled)
		{
			obj.resolveClipRef();
			isPlaying = clipIsPlaying(obj.clipRef, obj.mediaType)
			if (obj.playing != isPlaying)
			{
				obj.playing = isPlaying;
				if (isPlaying)
				{
					obj.events.raiseEvent("play",obj.embedName);
				}
				else
				{
					obj.events.raiseEvent("stop",obj.embedName);
				}
			}
			else
			{
				obj.events.raiseEvent("timer",obj.embedName,getClipPosition(obj.clipRef, obj.mediaType));
			}
		}
	}

	setTimeout("MediaIdler()",mediaSyncInterval);
}

//////////////////////////////////
var mediaEventObjects = new Array();

function MediaEventsObject(strMediaEmbedName, strStartCode, strStopCode, strMediaType)
{
	this.id = mediaEventObjects.length;
	mediaEventObjects[this.id] = this;
	
	this.mSync = new MediaSync(strMediaEmbedName, strMediaType);

	eval("window.handleMediaPlay" + this.id + " = function(clipName){mediaEventObjects[" + this.id + "].handleMediaPlay(clipName)}");
	eval("window.handleMediaStop" + this.id + " = function(clipName){mediaEventObjects[" + this.id + "].handleMediaStop(clipName)}");
	eval("window.handleMediaTimer" + this.id + " = function(clipName, clipPosition){mediaEventObjects[" + this.id + "].handleMediaTimer(clipName, clipPosition)}");

	this.mSync.events.registerEvent("play", "handleMediaPlay" + this.id, window);
	this.mSync.events.registerEvent("stop", "handleMediaStop" + this.id, window);
	this.mSync.events.registerEvent("timer", "handleMediaTimer" + this.id, window);
	
	this.start = function () {this.mSync.start()};
	this.stop = function () {this.mSync.stop()};
	this.startCode = strStartCode;
	this.stopCode = strStopCode;
	this.lastPosition = 0;
	
	this.arrEvents = new Array();
	
	return this;
}
MediaEventsObject.prototype.handleMediaPlay = MediaEventObjectHandleMediaPlay;
MediaEventsObject.prototype.handleMediaStop = MediaEventObjectHandleMediaStop;
MediaEventsObject.prototype.handleMediaTimer = MediaEventObjectHandleMediaTimer;
MediaEventsObject.prototype.addEvent = MediaEventObjectAddEvent;

function MediaEventObjectAddEvent(strCode, intPos)
{
	var index = this.arrEvents.length;

	this.arrEvents[index] = new MedEvtObj(strCode, intPos);
}

function MediaEventObjectHandleMediaPlay(clipName)
{
	eval(this.startCode);
	this.lastPosition = 0;
}

function MediaEventObjectHandleMediaStop(clipName)
{
	eval(this.stopCode);
	for (var i=0;i<this.arrEvents.length;i++)
	{
		this.arrEvents[i].enabled = true;
	}
}

function MediaEventObjectHandleMediaTimer(clipName, clipPosition)
{
	var i = 0;
	var objEvt = null;
	
	if (this.lastPosition > clipPosition) {if (clipPosition > 0) {this.handleMediaStop(clipName);this.handleMediaPlay(clipName);};};
	this.lastPosition = clipPosition;
	
	for (i=0;i<this.arrEvents.length;i++)
	{
		objEvt = this.arrEvents[i];
		if (objEvt.enabled)
		{
			if (clipPosition >= objEvt.position)
			{
				objEvt.enabled = false;
				eval(objEvt.code);
			}
		}
		else
		{
			if (!(clipPosition >= objEvt.position))
			{
				objEvt.enabled = true;
			}
		}
	}
}

function MedEvtObj(strCode, intPos)
{
	this.code = strCode;
	this.position = intPos;
	this.enabled = true;
	
	return this;
}